Scriptname zBFSShockCritical extends activemagiceffect  

Spell property BFSDeadSpell auto
Spell property BFSConvulseSpell auto
Spell property BFSDeadMagicSpell auto
Spell property BFSDeadShaderSpell auto

MagicEffect property ShockConvulsionME auto

EffectShader property BlankShader auto
EffectShader property MagicEffectShader auto
EffectShader property MagicEffectShaderSmall auto
EffectShader property CalcinatedTexture auto
EffectShader property SmokeFX auto

GlobalVariable property GlobalEffectsMeat auto
GlobalVariable property GlobalEffectsPelt auto

Ingredient property CharredSkeeverHide auto

MiscObject property BearCavePelt auto
MiscObject property BearPelt auto
MiscObject property BearSnowPelt auto
MiscObject property Cowhide auto
MiscObject property DeerHide auto
MiscObject property DeerHide02 auto
MiscObject property FoxPelt auto
MiscObject property FoxPeltSnow auto
MiscObject property GoatHide auto
MiscObject property HorseHide auto
MiscObject property SabreCatPelt auto
MiscObject property SabreCatSnowPelt auto
MiscObject property WerewolfPelt auto
MiscObject property WolfPelt auto
MiscObject property WolfIcePelt auto
MiscObject property DLC1DeerHide auto
MiscObject property DLC1SabrecatHide auto
MiscObject property DLC2NetchLeather auto

Potion property FoodBeef auto
Potion property FoodBeefCooked auto
Potion property FoodChicken auto
Potion property FoodChickenCooked auto
Potion property FoodGoatMeat auto
Potion property FoodGoatMeatCooked auto
Potion property FoodHorkerMeat auto
Potion property FoodHorkerMeatCooked auto
Potion property FoodHorseMeat auto
Potion property FoodHorseMeatCooked auto
Potion property FoodMammothMeat auto
Potion property FoodMammothMeatCooked auto
Potion property FoodPheasant auto
Potion property FoodPheasantCooked auto
Potion property FoodRabbit auto
Potion property FoodRabbitCooked auto
Potion property FoodSalmon auto
Potion property FoodSalmonCooked auto
Potion property FoodSlaughterfishCooked auto
Potion property FoodVenison auto
Potion property FoodVenisonCooked auto
Potion property DLC2FoodAshHopperLeg auto
Potion property DLC2FoodAshHopperMeat auto
Potion property DLC2FoodBoarMeat auto
Potion property DLC2FoodBoarMeatCooked auto

Race property SlaughterfishRace auto
Race property SkeeverRace auto
Race property SkeeverWhiteRace auto
Keyword property Dwarven auto

actor caster
actor target
race targetrace
int targethealth
int random
float GlobalMeat
float GlobalPelt
bool bShader = false
bool Sparks = false


EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	caster = akCaster
	target = akTarget
	targetrace = target.GetRace()

	SparkVisual()
endEvent

Function SparkVisual()
	;;; Apply some small sparks if is not essential for decoration
	if targethealth <= 0 && !target.IsEssential() && !Sparks
		random = Utility.RandomInt(5, 10)
		MagicEffectShaderSmall.play(target, random)
		Sparks = true
	endif	
endfunction

EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	GlobalMeat = GlobalEffectsMeat.GetValue()
	GlobalPelt = GlobalEffectsPelt.GetValue()
	targethealth = target.GetAV("health") as int

	SparkVisual()

	if target.IsDead()
		if !target.HasSpell(BFSDeadMagicSpell)
			random = Utility.RandomInt(20, 40)
			MagicEffectShader.play(target, random)
			target.AddSpell(BFSDeadMagicSpell, false)
		endif

		if !target.HasKeyword(Dwarven)
			if !target.HasMagicEffect(ShockConvulsionME)
				BFSConvulseSpell.Cast(caster, target)
			endif
				target.AddSpell(BFSDeadSpell, false)
				target.AddSpell(BFSDeadShaderSpell, false)
				random = Utility.RandomInt(100, 140)
				BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
				bShader = true
				SmokeFX.play(target, random)
				PeltsAndFood()
		endif
			utility.Wait(1)		;; necessary to avoid the effects not showing
	endif

	if bShader == true
		CalcinatedTexture.play(target)
	endif
endEvent


FUNCTION PeltsAndFood()
;;; ===If has any meat, change it for a cooked version===
if GlobalMeat == 1	;; Allow burning meat
	if target.GetItemCount(FoodBeef) != 0
		target.AddItem(FoodBeefCooked, target.GetItemCount(FoodBeef), true)
		target.RemoveItem(FoodBeef, target.GetItemCount(FoodBeef))
	endif
	if target.GetItemCount(FoodChicken) != 0
		target.AddItem(FoodChickenCooked, target.GetItemCount(FoodChicken), true)
		target.RemoveItem(FoodChicken, target.GetItemCount(FoodChicken))
	endif
	if target.GetItemCount(FoodGoatMeat) != 0
		target.AddItem(FoodGoatMeatCooked, target.GetItemCount(FoodGoatMeat), true)
		target.RemoveItem(FoodGoatMeat, target.GetItemCount(FoodGoatMeat))
	endif
	if target.GetItemCount(FoodHorkerMeat) != 0
		target.AddItem(FoodHorkerMeatCooked, target.GetItemCount(FoodHorkerMeat), true)
		target.RemoveItem(FoodHorkerMeat, target.GetItemCount(FoodHorkerMeat))
	endif
	if target.GetItemCount(FoodHorseMeat) != 0
		target.AddItem(FoodHorseMeatCooked, target.GetItemCount(FoodHorseMeat), true)
		target.RemoveItem(FoodHorseMeat, target.GetItemCount(FoodHorseMeat))
	endif
	if target.GetItemCount(FoodMammothMeat) != 0
		target.AddItem(FoodMammothMeatCooked, target.GetItemCount(FoodMammothMeat), true)
		target.RemoveItem(FoodMammothMeat, target.GetItemCount(FoodMammothMeat))
	endif
	if target.GetItemCount(FoodPheasant) != 0		;; I think this one is imposible to accomplish
		target.AddItem(FoodPheasantCooked, target.GetItemCount(FoodPheasant), true)
		target.RemoveItem(FoodPheasant, target.GetItemCount(FoodPheasant))
	endif
	if target.GetItemCount(FoodRabbit) != 0
		target.AddItem(FoodRabbitCooked, target.GetItemCount(FoodRabbit), true)
		target.RemoveItem(FoodRabbit, target.GetItemCount(FoodRabbit))
	endif
	if target.GetItemCount(FoodSalmon) != 0		;; This one will be imposible unless a npc (not a salmon) has this item
		target.AddItem(FoodSalmonCooked, target.GetItemCount(FoodSalmon), true)
		target.RemoveItem(FoodSalmon, target.GetItemCount(FoodSalmon))
	endif
	if target.GetItemCount(FoodVenison) != 0
		target.AddItem(FoodVenisonCooked, target.GetItemCount(FoodVenison), true)
		target.RemoveItem(FoodVenison, target.GetItemCount(FoodVenison))
	endif
	;;; ===Add cooked items that don't have a raw version on some races randomly===
	if targetrace == SlaughterfishRace && target.GetItemCount(FoodSlaughterfishCooked) == 0
		random = Utility.RandomInt(0, 100)
		if random <= 50
			target.AddItem(FoodSlaughterfishCooked, 1, true)
		endif
	endif
	if targetrace == SkeeverRace || targetrace == SkeeverWhiteRace
		if target.GetItemCount(CharredSkeeverHide) == 0
			random = Utility.RandomInt(0, 100)
			if random <= 50
				target.AddItem(CharredSkeeverHide, 1, true)
			endif
		endif
	endif
	;;; === If Dragonborn is installed ===
	if DLC2FoodAshHopperLeg != NONE
		if target.GetItemCount(DLC2FoodAshHopperLeg) != 0
			target.RemoveItem(DLC2FoodAshHopperLeg, target.GetItemCount(DLC2FoodAshHopperLeg))
		endif
		if target.GetItemCount(DLC2FoodAshHopperMeat) != 0
			target.RemoveItem(DLC2FoodAshHopperMeat, target.GetItemCount(DLC2FoodAshHopperMeat))
		endif
		if target.GetItemCount(DLC2FoodBoarMeat) != 0
			target.AddItem(DLC2FoodBoarMeatCooked, target.GetItemCount(DLC2FoodBoarMeat), true)
			target.RemoveItem(DLC2FoodBoarMeat, target.GetItemCount(DLC2FoodBoarMeat))
		endif
	endif
endif
	;;; ===If has any pelt, destroy it===
if GlobalPelt == 1	;; Allow burning pelt
	if target.GetItemCount(BearCavePelt) != 0
		target.RemoveItem(BearCavePelt, target.GetItemCount(BearCavePelt))
	endif
	if target.GetItemCount(BearPelt) != 0
		target.RemoveItem(BearPelt, target.GetItemCount(BearPelt))
	endif
	if target.GetItemCount(BearSnowPelt) != 0
		target.RemoveItem(BearSnowPelt, target.GetItemCount(BearSnowPelt))
	endif
	if target.GetItemCount(CowHide) != 0
		target.RemoveItem(CowHide, target.GetItemCount(CowHide))
	endif
	if target.GetItemCount(DeerHide) != 0
		target.RemoveItem(DeerHide, target.GetItemCount(DeerHide))
	endif
	if target.GetItemCount(DeerHide02) != 0
		target.RemoveItem(DeerHide02, target.GetItemCount(DeerHide02))
	endif
	if target.GetItemCount(FoxPelt) != 0
		target.RemoveItem(FoxPelt, target.GetItemCount(FoxPelt))
	endif
	if target.GetItemCount(FoxPeltSnow) != 0
		target.RemoveItem(FoxPeltSnow, target.GetItemCount(FoxPeltSnow))
	endif
	if target.GetItemCount(GoatHide) != 0
		target.RemoveItem(GoatHide, target.GetItemCount(GoatHide))
	endif
	if target.GetItemCount(HorseHide) != 0
		target.RemoveItem(HorseHide, target.GetItemCount(HorseHide))
	endif
	if target.GetItemCount(SabreCatPelt) != 0
		target.RemoveItem(SabreCatPelt, target.GetItemCount(SabreCatPelt))
	endif
	if target.GetItemCount(SabreCatSnowPelt) != 0
		target.RemoveItem(SabreCatSnowPelt, target.GetItemCount(SabreCatSnowPelt))
	endif
	if target.GetItemCount(WerewolfPelt) != 0
		target.RemoveItem(WerewolfPelt, target.GetItemCount(WerewolfPelt))
	endif
	if target.GetItemCount(WolfPelt) != 0
		target.RemoveItem(WolfPelt, target.GetItemCount(WolfPelt))
	endif
	if target.GetItemCount(WolfIcePelt) != 0
		target.RemoveItem(WolfIcePelt, target.GetItemCount(WolfIcePelt))
	endif
	if DLC1DeerHide != NONE	;; if Dawnguard is installed
		if target.GetItemCount(DLC1DeerHide) != 0
			target.RemoveItem(DLC1DeerHide, target.GetItemCount(DLC1DeerHide))
		endif
		if target.GetItemCount(DLC1SabrecatHide) != 0
			target.RemoveItem(DLC1SabrecatHide, target.GetItemCount(DLC1SabrecatHide))
		endif
	endif
	if DLC2NetchLeather != NONE	;; if Dragonborn is installed
		if target.GetItemCount(DLC2NetchLeather) != 0
			target.RemoveItem(DLC2NetchLeather, target.GetItemCount(DLC2NetchLeather))
		endif
	endif
endif
EndFunction